/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.compat.wthit;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.codecs.AgriSoil;
import com.agricraft.agricraft.api.crop.AgriCrop;
import com.agricraft.agricraft.api.requirement.AgriGrowthConditionRegistry;
import com.agricraft.agricraft.api.requirement.AgriGrowthResponse;
import com.agricraft.agricraft.api.stat.AgriStat;
import com.agricraft.agricraft.api.stat.AgriStatRegistry;
import com.agricraft.agricraft.common.block.CropBlock;
import com.agricraft.agricraft.common.util.LangUtils;
import java.util.Comparator;
import java.util.Optional;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2586;

public class AgriCraftWthitPlugin
implements IWailaPlugin {
    public void register(IRegistrar registrar) {
        registrar.addComponent((IBlockComponentProvider)CropBlockComponentProvider.INSTANCE, TooltipPosition.BODY, CropBlock.class);
        registrar.addComponent((IBlockComponentProvider)SoilComponentProvider.INSTANCE, TooltipPosition.BODY, class_2248.class);
    }

    public static class CropBlockComponentProvider
    implements IBlockComponentProvider {
        public static final CropBlockComponentProvider INSTANCE = new CropBlockComponentProvider();

        public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
            class_2586 class_25862 = accessor.getBlockEntity();
            if (class_25862 instanceof AgriCrop) {
                AgriCrop crop = (AgriCrop)class_25862;
                if (crop.hasPlant()) {
                    tooltip.addLine((class_2561)class_2561.method_43469((String)"agricraft.tooltip.jade.growth", (Object[])new Object[]{crop.getGrowthPercent() * 100.0}));
                    if (accessor.getPlayer().method_5715()) {
                        tooltip.addLine((class_2561)class_2561.method_43471((String)"agricraft.tooltip.jade.species").method_10852(LangUtils.plantName(crop.getGenome().getSpeciesGene().getTrait())));
                        AgriStatRegistry.getInstance().stream().filter(stat -> !stat.isHidden()).map(stat -> crop.getGenome().getStatGene((AgriStat)stat)).sorted(Comparator.comparing(p -> p.getGene().getId())).map(genePair -> class_2561.method_43469((String)("agricraft.tooltip.jade.stat." + genePair.getGene().getId()), (Object[])new Object[]{genePair.getTrait()})).forEach(arg_0 -> ((ITooltip)tooltip).addLine(arg_0));
                        AgriGrowthResponse response = crop.getFertilityResponse();
                        tooltip.addLine((class_2561)class_2561.method_43471((String)("agricraft.tooltip.magnifying.requirement." + (response.isLethal() ? "lethal" : (response.isFertile() ? "fertile" : "not_fertile")))));
                        if (crop.method_10997().field_9236) {
                            crop.method_10997().method_8533();
                        }
                        if (!response.isFertile()) {
                            int strength = crop.getGenome().getStrength();
                            AgriGrowthConditionRegistry.getInstance().stream().filter(condition -> !condition.check(crop, crop.method_10997(), crop.method_11016(), strength).isFertile()).forEach(condition -> condition.notMetDescription(arg_0 -> ((ITooltip)tooltip).addLine(arg_0)));
                        }
                    }
                } else {
                    tooltip.addLine((class_2561)class_2561.method_43471((String)"agricraft.tooltip.magnifying.no_plant"));
                }
                if (crop.hasWeeds()) {
                    tooltip.addLine((class_2561)class_2561.method_43471((String)"agricraft.tooltip.magnifying.weeds").method_10852(LangUtils.weedName(crop.getWeedId())));
                    if (accessor.getPlayer().method_5715()) {
                        tooltip.addLine((class_2561)class_2561.method_43470((String)"  ").method_10852((class_2561)class_2561.method_43469((String)"agricraft.tooltip.magnifying.growth", (Object[])new Object[]{crop.getWeedGrowthStage().index() + 1, crop.getWeedGrowthStage().total()})));
                    }
                }
            }
        }
    }

    public static class SoilComponentProvider
    implements IBlockComponentProvider {
        public static final SoilComponentProvider INSTANCE = new SoilComponentProvider();

        public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
            Optional<AgriSoil> soil = AgriApi.getSoil((class_1922)accessor.getWorld(), accessor.getPosition(), accessor.getWorld().method_30349());
            if (soil.isPresent() && accessor.getPlayer().method_5715()) {
                AgriSoil soil1 = soil.get();
                tooltip.addLine((class_2561)class_2561.method_43471((String)"agricraft.tooltip.magnifying.soil.humidity").method_10852((class_2561)class_2561.method_43471((String)("agricraft.soil.humidity." + soil1.humidity().name().toLowerCase()))));
                tooltip.addLine((class_2561)class_2561.method_43471((String)"agricraft.tooltip.magnifying.soil.acidity").method_10852((class_2561)class_2561.method_43471((String)("agricraft.soil.acidity." + soil1.acidity().name().toLowerCase()))));
                tooltip.addLine((class_2561)class_2561.method_43471((String)"agricraft.tooltip.magnifying.soil.nutrients").method_10852((class_2561)class_2561.method_43471((String)("agricraft.soil.nutrients." + soil1.nutrients().name().toLowerCase()))));
            }
        }
    }
}

